package State;

class OrderContext {
    private OrderState currentState;

    public OrderContext() {
        this.currentState = new WaitingForPayment(); // Stato iniziale
    }

    public void setState(OrderState state) {
        this.currentState = state;
    }

    public void process() {
        if (currentState != null) {
            currentState.processOrder(this);
        }
    }
}